import { z } from "zod"

export const appNoBuildInProgressOption = "NO BUILD" as const

const noBuildInProgressOptionSchema = z.literal(appNoBuildInProgressOption)

const validationStatusOptionSchema = z.union([
  z.literal("RUNNING"),
  z.literal("SUCCEEDED"),
  z.literal("FAILED"),
  z.literal("TIMED_OUT"),
  z.literal("ABORTED"),
  z.literal("PENDING_REDRIVE"),
])

export const validationStatusOptionExtendedSchema = z.union([
  validationStatusOptionSchema,
  noBuildInProgressOptionSchema,
])

const validationErrorSchema = z.string().optional();

export const validationStatusSchema = z.object({
  startDate: z.string().optional(),
  status: validationStatusOptionSchema.optional(),
  error: validationErrorSchema,
})

export const agencyAccessSchema = z.union([
  z.literal("UNKNOWN"),
  z.literal("VIEW_ONLY"),
  z.literal("ALL"),
])

export const otpFeedStatusSchema = z.object({
  agency_access: agencyAccessSchema.optional().nullable(),
  gtfsId: z.string(),
  path: z.string(),
  id: z.string(),
  url: z.string(),
  name: z.string(),
  phone: z.string(),
  agency_id: z.string(),
  date_upload: z.string().nullable(),
  date_preview: z.string().nullable(),
  date_live: z.string().nullable(),
  validation_status: validationStatusSchema,
})

export const otpFeedStatusesSchema = z.array(otpFeedStatusSchema)

export const otpFeedStatusesResponseSchema = z.object({
  body: otpFeedStatusesSchema.optional(),
  statusCode: z.number().optional(),
})

export type AppOtpFeedStatusAgencyAccessOption = z.infer<typeof agencyAccessSchema>

export type AppOtpFeedStatus = z.infer<typeof otpFeedStatusSchema>
export type AppOtpFeedStatuses = z.infer<typeof otpFeedStatusesSchema>
export type AppOtpFeedStatusesResponse = z.infer<typeof otpFeedStatusesResponseSchema>

export type AppNoBuildInProgressOption = typeof appNoBuildInProgressOption;
export type AppValidationStatusOption = z.infer<typeof validationStatusOptionExtendedSchema>
export type AppValidationStatus = z.infer<typeof validationStatusSchema>
export type AppValidationError = z.infer<typeof validationErrorSchema>
